
from django.shortcuts import render, redirect
from django.contrib import messages
from .models import Complaint

def complaint_create(request):
    if request.method == 'POST':
        Complaint.objects.create(
            name=request.POST['name'],
            email=request.POST['email'],
            subject=request.POST['subject'],
            message=request.POST['message']
        )
        messages.success(request, "Complaint submitted successfully!")
        return redirect('/')
    return render(request, 'complaint_form.html')

def admin_complaints(request):
    data = Complaint.objects.all().order_by('-created_at')
    return render(request, 'admin_complaints.html', {'complaints': data})

def resolve(request, id):
    c = Complaint.objects.get(id=id)
    c.status = 'Resolved'
    c.save()
    return redirect('/admin-complaints/')

def delete(request, id):
    Complaint.objects.get(id=id).delete()
    return redirect('/admin-complaints/')
